const figlet = require("figlet");
const ansis = require("ansis");

const xiapaziHost = 'http://www.xiapazi.site'
const template = '@peace/react_client'

module.exports.actionRecord = async ({
   action, spend, env
}) => {
   try {
      fetch(`${xiapaziHost}/api/ftar`, {
         method: 'POST',
         headers: {
            'Content-Type': 'application/json',
         },
         body: JSON.stringify({
            template, action, spend, env
         })
      }).catch(()=>{

      });
   } catch (error) {

   }
}

module.exports.actionAvg = async ({
   action, env
}) => {
   try {
      const params = new URLSearchParams({
         template, action, env
      });
      fetch(`${xiapaziHost}/api/ftavg?${params.toString()}`, {
         method: 'GET',
         headers: {
            'Content-Type': 'application/json',
         },
      }).catch(()=>{
        
      });
   } catch (error) {

   }
}

module.exports.consolePeace = () => {
   console.log(
      figlet.textSync("@ PEACE", { whitespaceBreak: false, horizontalLayout: 'fitted', font: 'Soft', }),
      // 'by 附离'
   )
}

module.exports.consoleMore = () => {
   console.log(ansis.hex('#ff770f').bold('✔ 更多内容尽在 ') + ansis.hex('#00F5FF').bold(`${xiapaziHost}/#/fs@peace`));
}
