'use strict';
const fs = require('fs');
const path = require('path');
const Router = require('@koa/router');
//

module.exports.router = class fsRouter extends Router {
   constructor(name) {
      super(name); // 调用父类的构造函数
   }

   #router (method, path, middleware) {
      const conf = middleware.at(-1)
      if (typeof conf == 'object' && conf.content) {
         middleware.pop()
      }
      super[method](path, ...middleware);
   }

   get (path, ...middleware) {
      this.#router('get', path, middleware);
   }
   post (path, ...middleware) {
      this.#router('post', path, middleware);
   }
   put (path, ...middleware) {
      this.#router('put', path, middleware);
   }
   delete (path, ...middleware) {
      this.#router('delete', path, middleware);
   }
}

module.exports.routes = (app, router, conf, routerDirPath, load) => {
   router.get('/healthz', async function (ctx, next) {
      //k8s 探针用
      try {
         ctx.status = 200;
         ctx.body = 'ok';
      } catch (error) {
         console.error('[app]', error)
      }
   });
   require(routerDirPath)(app, router, conf);

   return router.routes()
}
