const react = require('@vitejs/plugin-react')
const path = require('path')

module.exports = async ({ cwd, env, userConf = {}, target }) => {
   return {
      configFile: false,
      root: cwd,
      base: '/',
      server: { middlewareMode: 'ssr', open: true, },
      // appType: 'spa',  // 此处打开 则不会经过下面的 vite.ssrLoadModule
      appType: 'custom',
      plugins: [react()],
      css: {
         modules: false, // 禁用CSS Modules
      },
      build: {
         ssr: target == 'server' ? path.join(cwd, 'client/entry/server.jsx') : undefined,
         ssrManifest: target == 'client' ? true : undefined,
         outDir: target == 'dev' ? undefined :
            path.join(cwd, target == 'server' ? 'dist/server' : 'dist/client'),
         rollupOptions: {
            // output: {
            //    // 手动控制代码分割
            //    manualChunks (id) {
            //       // 按关键字打包
            //       if (id.includes('node_modules/@ant') || id.includes('node_modules/antd')) {
            //          return 'antd';
            //       }
            //       if (id.includes('node_modules/')) {
            //          return 'vendor';
            //       }
            //       // 其他逻辑...
            //       return undefined; // 让 Rollup 自动处理
            //    },
            // },
         },
      },
      ...userConf,
   }
}
