import React from "react";
import { Table, Button, Radio } from "antd";
import { EditOutlined } from "@ant-design/icons";

const TemplateList = ({
   tempListData,
   selectedTemplate,
   onTemplateSelect,
   onAddTemplate,
   onEditTemplate,
}) => {
   const tempColumns = [
      {
         title: "模板选择",
         dataIndex: "name",
         key: "name",
         render: (text, record) => (
            <div
               style={{
                  display: "flex",
                  alignItems: "center",
                  justifyContent: "space-between",
                  padding: "8px 0",
               }}
            >
               <div style={{ display: "flex", alignItems: "center" }}>
                  <Radio
                     checked={selectedTemplate === record.key}
                     onChange={() => onTemplateSelect(record.key)}
                     style={{ marginRight: "12px" }}
                  />
                  <span
                     style={{
                        fontSize: "14px",
                        color: "#333",
                        marginRight: "12px",
                     }}
                  >
                     {text}
                  </span>
                  {record.imageUrl && (
                     <img
                        src={record.imageUrl}
                        alt={`${text} 模板图片`}
                        style={{
                           width: "40px",
                           height: "40px",
                           objectFit: "cover",
                           border: "1px solid #d9d9d9",
                           borderRadius: "4px",
                        }}
                     />
                  )}
               </div>
               <Button
                  type="text"
                  size="small"
                  icon={<EditOutlined />}
                  onClick={(e) => {
                     e.stopPropagation();
                     onEditTemplate(record);
                  }}
                  style={{
                     color: "#1890ff",
                     fontSize: "12px",
                     padding: "4px 8px",
                  }}
               >
                  编辑
               </Button>
            </div>
         ),
      },
   ];

   return (
      <div style={{ flex: 1, overflow: "auto", padding: "0 16px" }}>
         <Table
            dataSource={tempListData}
            columns={tempColumns}
            pagination={false}
            size="small"
            style={{ height: "100%" }}
            showHeader={false}
         />
         {tempListData.length < 3 && (
            <Button
               type="primary"
               style={{ marginTop: "16px", width: "100%" }}
               onClick={onAddTemplate}
            >
               添加新模板
            </Button>
         )}
      </div>
   );
};

export default TemplateList;
