const Command = require('common-bin');
const figlet = require("figlet");

class Cmd extends Command {
   constructor(rawArgv) {
      super(rawArgv);
      this.yargs.usage('Usage: peace-rc build [options]');
      this.options = {

      };
   }

   async run ({ cwd, env, argv, rawArgv }) {
      const startTime = new Date().getTime();
      console.log(
         figlet.textSync("@ PEACE", { whitespaceBreak: false, horizontalLayout: 'fitted', font: 'Soft', }),
         // 'by 附离'
      )

      require('../lib/build')({ cwd, env, argv, rawArgv, startTime })
   }
}

module.exports = Cmd;
// export default Cmd
