import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { isSame } from "../../utils/dateUtil";
import { getFromDate } from "../../utils/miscUtil";

/**
 * RangePicker need additional logic to handle the `disabled` case. e.g.
 * [disabled, enabled] should end date not before start date
 */
export default function useRangeDisabledDate(values, disabled, activeIndexList, generateConfig, locale, disabledDate) {
  var activeIndex = activeIndexList[activeIndexList.length - 1];
  var rangeDisabledDate = function rangeDisabledDate(date, info) {
    var _values = _slicedToArray(values, 2),
      start = _values[0],
      end = _values[1];
    var mergedInfo = _objectSpread(_objectSpread({}, info), {}, {
      from: getFromDate(values, activeIndexList)
    });

    // ============================ Disabled ============================
    // Should not select days before the start date
    if (activeIndex === 1 && disabled[0] && start &&
    // Same date isOK
    !isSame(generateConfig, locale, start, date, mergedInfo.type) &&
    // Before start date
    generateConfig.isAfter(start, date)) {
      return true;
    }

    // Should not select days after the end date
    if (activeIndex === 0 && disabled[1] && end &&
    // Same date isOK
    !isSame(generateConfig, locale, end, date, mergedInfo.type) &&
    // After end date
    generateConfig.isAfter(date, end)) {
      return true;
    }

    // ============================= Origin =============================
    return disabledDate === null || disabledDate === void 0 ? void 0 : disabledDate(date, mergedInfo);
  };
  return rangeDisabledDate;
}