import { apiTable } from './api'

import { request, basicAction, basicReducer } from '@peace/react_client'
import { message } from 'antd'

const apiRequest = new request({
   proxy: '/_api',
   userKey: 'user', // session 中的用户key 值 用于拼接 token
   message: message, // 全局提示组件
   interceptor: (res, err) => { // 拦截器
      if (err) {
         if (err?.status === 401) {
            window.location.replace('/signin');
            sessionStorage.clear()
         }
         return err
      }
      return res
   }
})

export { basicAction, basicReducer, apiTable, apiRequest }
