const { createSlice, createAsyncThunk } = require("@reduxjs/toolkit");

const reducer = (sections, apiRequest) => {
   let reducerMap = {}
   let requestMap = {}
   let repeatKey = []
   for (let sk in sections) {
      const { actions = {} } = sections[sk]
      for (let ak in actions) {
         if (repeatKey.includes(ak)) {
            console.warn(`action name ${ak} repeat`)
         }
         else {
            repeatKey.push(ak)
            const curAction = actions[ak]
            const slice = createSlice({
               name: curAction.reducerName || ak,
               initialState: {
                  data: null,
                  success: true,
                  error: null,
                  loading: false,
               },
               reducers: {
                  requestStart: (state, { payload }) => {
                     // state.data = null;
                     state.success = true;
                     state.error = null;
                     state.loading = true;
                  },
                  requestSuccess: (state, { payload }) => {
                     state.data = payload;
                     state.success = true;
                     state.error = null;
                     state.loading = false;
                  },
                  requestError: (state, { payload }) => {
                     state.data = null;
                     state.success = false;
                     state.error = payload;
                     state.loading = false;
                  },
                  requestCleardata: (state, { payload }) => {
                     state.data = null;
                     state.success = true;
                     state.error = null;
                     state.loading = false;
                  },
               },
            })
            const thunkRequest = createAsyncThunk(ak, async (payload = {}, thunkApi) => {
               thunkApi.dispatch(slice.actions.requestStart())
               return await new Promise((resolve, reject) => {
                  apiRequest[curAction.requestMethod](
                     curAction.requestUrl,
                     {
                        ...payload, // payload 就是真的发起请求的时候的参数
                        ...curAction.option
                     }
                  )
                     .then((res) => {
                        thunkApi.dispatch(slice.actions.requestSuccess(res.body || res.text))
                        resolve({
                           data: res.body || res.text,
                           success: true,
                           error: null,
                           loading: false,
                        })
                     })
                     .catch((err) => {
                        console.error(err)
                        thunkApi.dispatch(slice.actions.requestError(err))
                        resolve({
                           data: null,
                           success: false,
                           error: err,
                           loading: false,
                        })
                     })
               })
            });
            reducerMap[curAction.option.reducerName || ak] = slice.reducer
            requestMap[ak] = thunkRequest
         }
      }
   }
   return { reducerMap, requestMap }
}

module.exports = reducer;
