import React, { useContext } from "react";
import { Layout, Dropdown, Space, theme } from "antd";
import { UserOutlined } from "@ant-design/icons";
import { useNavigate } from "react-router-dom";
import fsLogo from "@assets/img/fs_logo_banner.png";

const { Header } = Layout;

export default function header () {
   const navigate = useNavigate();
   const userInfo = JSON.parse(sessionStorage.getItem("user"));

   const { token: { colorBgContainer }, } = theme.useToken();

   return (
      <Header style={{ padding: '0 24px', background: colorBgContainer, display: "flex", justifyContent: "space-between", alignItems: "center", boxShadow: '0px 3px 6px -4px rgba(0, 0, 0, 0.12)', zIndex: 1 }}>
         <div style={{ display: 'flex' }}>
            <img style={{ height: 40, }} src={fsLogo} />
         </div>
         <Dropdown
            menu={{
               items: [{
                  label: <div onClick={() => {
                     navigate("/signin");
                     sessionStorage.removeItem("user");
                  }}>
                     退出登录
                  </div>,
                  key: "logout",
               },]
            }}
         >
            <a onClick={e => e.preventDefault()}>
               <Space>
                  <UserOutlined />
                  {userInfo?.name}
               </Space>
            </a>
         </Dropdown>
      </Header>
   );
}
