import { LockOutlined, UserOutlined } from "@ant-design/icons";
import { useEffect } from "react";
import { useDispatch, useSelector } from "react-redux";
import { useNavigate } from "react-router-dom";
import { Button, Form, Input, Flex } from "antd";
import "./login.less";

export default function login() {
   const dispatch = useDispatch();
   const navigate = useNavigate();

   const actions = useSelector((state) => state.global.actions);
   const onFinish = (values) => {
      dispatch(
         actions.login({
            body: { ...values },
            params: {},
         })
      ).then((res) => {
         const { success, data } = res.payload;
         if (success) {
            sessionStorage.setItem("user", JSON.stringify(data));
            navigate("/");
         }
      });
   };

   useEffect(() => {
      sessionStorage.clear();
   }, []);

   return (
      <div
         className="login"
         style={{
            height: "100vh",
            width: "100vw",
            display: "flex",
            justifyContent: "flex-end",
         }}
      >
         <div
            style={{
               background: "rgba(255,255,255,0.2)",
               display: "flex",
               alignItems: "center",
               justifyContent: "center",
            }}
         >
            <Form
               size="large"
               onFinish={onFinish}
               style={{ width: "24vw", minWidth: 320, padding: 24 }}
            >
               <Form.Item
                  name="username"
                  rules={[
                     {
                        required: true,
                        message: "请输入用户名",
                     },
                  ]}
               >
                  <Input prefix={<UserOutlined />} placeholder="用户名" />
               </Form.Item>
               <Form.Item
                  name="password"
                  rules={[
                     {
                        required: true,
                        message: "请输入密码",
                     },
                  ]}
               >
                  <Input
                     prefix={<LockOutlined />}
                     type="password"
                     placeholder="密码"
                  />
               </Form.Item>
               <Form.Item>
                  <Button block type="primary" htmlType="submit">
                     登录
                  </Button>
               </Form.Item>
            </Form>
         </div>
      </div>
   );
}
