import React, { useState } from 'react';
import { Card, Input, Button, message } from 'antd';
import { LockOutlined } from '@ant-design/icons';

/**
 * 高级配置密码验证组件
 */
const AdvancedConfigAuth = ({ verifyPassword, onUnlock }) => {
   const [password, setPassword] = useState('');
   const [loading, setLoading] = useState(false);

   const handleVerify = async () => {
      if (!password) {
         message.warning('请输入密码');
         return;
      }

      setLoading(true);
      try {
         const isValid = await verifyPassword(password);

         if (isValid) {
            message.success('密码正确，已解锁高级配置');
            onUnlock && onUnlock();
         } else {
            message.error('密码错误，请重试');
            setPassword('');
         }
      } catch (error) {
         console.error('密码验证失败:', error);
         message.error('验证过程出错，请重试');
      } finally {
         setLoading(false);
      }
   };

   const handleKeyPress = (e) => {
      if (e.key === 'Enter') {
         handleVerify();
      }
   };

   return (
      <div
         style={{
            display: 'flex',
            alignItems: 'center',
            justifyContent: 'center',
            minHeight: 'calc(100vh - 92px)',
            padding: '24px',
         }}
      >
         <Card
            style={{
               width: 400,
               textAlign: 'center',
               boxShadow: '0 2px 8px rgba(0,0,0,0.1)',
            }}
         >
            <div
               style={{
                  width: 64,
                  height: 64,
                  borderRadius: '50%',
                  backgroundColor: '#e6f4ff',
                  display: 'flex',
                  alignItems: 'center',
                  justifyContent: 'center',
                  margin: '0 auto 24px',
               }}
            >
               <LockOutlined style={{ fontSize: 32, color: '#1890ff' }} />
            </div>

            <h2 style={{ marginBottom: 8 }}>内部高级配置</h2>
            <p style={{ color: '#999', marginBottom: 24 }}>
               请输入管理员访问密码以继续
            </p>

            <Input.Password
               size="large"
               placeholder="请输入密码"
               value={password}
               onChange={(e) => setPassword(e.target.value)}
               onKeyPress={handleKeyPress}
               prefix={<LockOutlined style={{ color: '#999' }} />}
               style={{ marginBottom: 16 }}
            />

            <Button
               type="primary"
               size="large"
               block
               loading={loading}
               onClick={handleVerify}
            >
               解锁配置
            </Button>

            <div
               style={{
                  marginTop: 24,
                  fontSize: 12,
                  color: '#999',
               }}
            >
               视觉位移计配置工具 v{window.env?.FS_VERSION || ''} Build {new Date().getFullYear()}
            </div>
         </Card>
      </div>
   );
};

export default AdvancedConfigAuth;
