#!/bin/bash
# 环境检查脚本

echo "检查部署环境..."

# 检查 Node.js
if command -v node &> /dev/null; then
    NODE_VERSION=$(node -v)
    echo "✓ Node.js 已安装: $NODE_VERSION"

    # 检查版本是否 >= 20
    NODE_MAJOR_VERSION=$(node -v | cut -d'v' -f2 | cut -d'.' -f1)
    if [ "$NODE_MAJOR_VERSION" -ge 20 ]; then
        echo "✓ Node.js 版本符合要求 (v20+)"
    else
        echo "✗ Node.js 版本过低，需要 v20+"
        exit 1
    fi
else
    echo "✗ Node.js 未安装"
    echo "请先安装 Node.js 20+:"
    echo "curl -fsSL https://deb.nodesource.com/setup_20.x | sudo -E bash -"
    echo "sudo apt-get install -y nodejs"
    exit 1
fi

# 检查 npm
if command -v npm &> /dev/null; then
    echo "✓ npm 已安装: $(npm -v)"
else
    echo "✗ npm 未安装"
    exit 1
fi

# 检查 systemd
if systemctl --version &> /dev/null; then
    echo "✓ systemd 可用"
else
    echo "✗ systemd 不可用，将无法设置开机自启"
fi

echo "环境检查完成!"
