
const multer = require('@koa/multer');
const { setupTcpProxy } = require('./tcpProxy');
const upload = multer({
   limits: { fileSize: 500 * 1024 * 1024 } // 将文件大小限制设置为200MB
});
//
const xunruan = require('./controllers/xunruan.js');



// ... 路由都写在这里
module.exports = async (app, router, conf) => {
   // 讯软相关接口
   router.post('/xunruan/decryption',
      upload.single('file'),
      xunruan.decryption,
      { content: '讯软解密', visible: true }
   );
   // 设置TCP代理
   setupTcpProxy(conf);
}
