import React, { useEffect, useState } from "react";
import { LeftOutlined } from "@ant-design/icons";
import { Layout } from "antd";
import Sider from "../components/sider";
import Content from "../components/content";
import Header from "../components/header.jsx";
import './index.less'

export default (props) => {
   const [collapsed, setCollapsed] = useState(false);

   useEffect(() => {
      if (!sessionStorage.getItem("user")) {
         window.location.replace("/wuyuanbiaoba");
      }
   }, []);

   return (
      <Layout style={{ height: "100vh", }}   >
         <Header />
         <Layout>
            <Sider collapsed={collapsed} routerNav={props.routerNav} />
            <div style={{ alignContent: 'center', padding: '0 2px', }}>
               <LeftOutlined className={`collaps-icon ${collapsed ? 'collapsed' : ''}`} onClick={() => setCollapsed(!collapsed)} />
            </div>
            <Content routerNav={props.routerNav} />
         </Layout>
      </Layout>
   );
}
