const path = require('path');
const crypto = require('crypto');

const replaceFalseString = (obj) => {
   if (obj === null || typeof obj !== 'object') {
      // 如果 obj 不是对象或为空，则直接返回
      return obj;
   }

   if (Array.isArray(obj)) {
      // 如果 obj 是数组，则遍历数组中的每个元素并递归处理
      return obj.map(item => replaceFalseString(item));
   }

   // 遍历对象的每个属性
   const newObj = {};
   for (const key in obj) {
      if (obj[key]) {
         const value = obj[key];
         if (typeof value === 'string' && value === 'false') {
            // 如果值是字符串 "false"，则重置为布尔值 false
            newObj[key] = false;
         } else {
            // 否则，递归处理该值
            newObj[key] = replaceFalseString(value);
         }
      }
   }

   return newObj;
}

module.exports.replaceFalseString = replaceFalseString

/**
 * 为文件名添加随机字符串
 * @param {string} filePath - 文件的完整路径
 * @returns {string} - 新的文件名，包含随机字符串
 */
module.exports.addRandomStringToFileName = (filePath) => {
   // 获取文件名和扩展名
   const fileName = path.basename(filePath, path.extname(filePath)); // 去掉扩展名
   const extname = path.extname(filePath); // 获取扩展名

   // 生成一个随机字符串
   const randomString = crypto.randomBytes(6).toString('hex'); // 生成12位十六进制字符串

   // 拼接新的文件名
   const newFileName = `${fileName}-${randomString}${extname}`;

   return newFileName;
}
