import React from "react";
import { Table, Button } from "antd";
import { EditOutlined } from "@ant-design/icons";

const TargetList = ({
   targetListData,
   selectedTargetId,
   onEditTarget,
   onSelectTarget,
   onClickClearAll,
}) => {

   const targetColumns = [
      {
         title: "标靶操作",
         dataIndex: "name",
         key: "name",
         render: (text, record) => (
            <div
               style={{
                  display: "flex",
                  alignItems: "center",
                  justifyContent: "space-between",
                  padding: "8px 0",
                  backgroundColor:
                     selectedTargetId === record.id ? "#e6f7ff" : "transparent",
                  borderRadius: "4px",
                  cursor: "pointer",
                  transition: "background-color 0.2s",
               }}
               onClick={() => onSelectTarget(record)}
            >
               <span
                  style={{
                     fontSize: "14px",
                     color: selectedTargetId === record.id ? "#1890ff" : "#333",
                     fontWeight:
                        selectedTargetId === record.id ? "500" : "normal",
                  }}
               >
                  {text}
               </span>
               <Button
                  type="text"
                  size="small"
                  icon={<EditOutlined />}
                  onClick={(e) => {
                     e.stopPropagation(); // 阻止事件冒泡
                     onEditTarget(record);
                  }}
                  style={{
                     color: "#1890ff",
                     fontSize: "12px",
                     padding: "4px 8px",
                  }}
               >
                  编辑
               </Button>
            </div>
         ),
      },
   ];

   return (
      <div style={{ flex: 1, overflow: "auto", padding: "0 16px" }}>
         <Table
            dataSource={targetListData}
            columns={targetColumns}
            pagination={false}
            size="small"
            style={{ height: "100%" }}
            showHeader={false}
         />
         <Button
            type="primary"
            style={{ marginTop: "16px", width: "100%" }}
            onClick={onClickClearAll}
         >
            一键清零
         </Button>
      </div>
   );
};

export default TargetList;
