const { replaceFalseString } = require('./utils/func')
const { actionRecord } = require('./private');
const { addRandomStringToFileName } = require('./utils/func')
const fs = require('fs-extra');
const path = require('path')

module.exports = async ({ cwd, env, argv, rawArgv, startTime = new Date().getTime() }) => {
   const conf = replaceFalseString(
      require(path.join(cwd, '/config.cjs'))
   )

   const { build } = await import('vite')

   await build(await require('./vite.config')({ cwd, env, userConf: conf?.vite, target: 'server' }))
   await build(await require('./vite.config')({ cwd, env, userConf: conf?.vite, target: 'client' }))

   let templateHtmlPath = path.join(cwd, '/dist/client/index.html')
   let templateHtml = fs.readFileSync(templateHtmlPath, 'utf-8')
   if (conf?.favicon) {
      const fileName = addRandomStringToFileName(conf?.favicon);
      let distPath = path.join('/assets/', fileName)
      fs.copySync(path.join(cwd, conf?.favicon), path.join(cwd, '/dist/client/assets/', fileName));

      templateHtml = templateHtml.replace(`<!--app-ico-->`, distPath ?? '')
   }

   if (conf?.scripts) {
      templateHtml = templateHtml.replace(`<!--app-script-->`, conf?.scripts?.map(sc => {
         const fileName = addRandomStringToFileName(sc);
         let distPath = path.join('/assets/', fileName)
         fs.copySync(path.join(cwd, sc), path.join(cwd, '/dist/client/assets/', fileName));
         return `<script src="${distPath}"></script>`
      }).join('\n') ?? '')
   }

   fs.writeFileSync(templateHtmlPath, templateHtml, 'utf8');

   const endTime = new Date().getTime();
   actionRecord({
      action: 'build',
      spend: endTime - startTime,
      env: conf?.env
   })
}
