# 无源标靶上位机

## 开发注意事项

- 请确保在开发环境中，`server/tcpProxy/index.js` 文件中的 `TCP_HOST` 设置为下位机的实际 IP 地址
- 提交代码前，请将 `TCP_HOST` 设置回去
- 确保在生产环境中，[摄像头流地址](./client/src/sections/wuyuanbiaoba/components/CameraView.jsx),摄像头流的 streamUrl 指向正确的地址
- 提交代码前，请将 `streamUrl` 设置回去

## 本地开发

### 启动开发服务器

```bash
# 普通开发模式
npm start

# 本地开发模式（使用 localdev 环境标识）
npm run start:dev

# 自定义端口启动（默认端口为 5000）
npm start -- --port 3000
```

### 环境配置

项目使用 `config.cjs` 进行配置，支持以下环境变量：

- `NODE_ENV`: 运行环境（development | production）
- `PORT`: 服务端口（默认 5000）
- `API`: API 代理目标地址

本地开发模式（`npm run start:dev`）会自动设置 `FS_FLAG=localdev` 环境变量。

## 部署说明

### 部署步骤

**特别注意**
确保下位机已经安装了 nodejs 环境,并且版本在 20 以上(推荐v20.19.3)，注意，nodejs 环境必须是 root 用户可用的，服务自启动需要 systemd 的操作权限。

1. 从项目的 [release](https://gitea.anxinyun.cn/qinjian/wuyuanbiaoba_web/releases) 页面下载最新的打包文件,如 `wuyuanbiaoba-web-x.x.x.tar.gz`
2. 上传到服务器的临时目录,如 `~/deploy/`(这里最好建立一个新的目录存放压缩文件)
3. 进入该目录,解压文件 `tar -xzf wuyuanbiaoba-web-x.x.x.tar.gz`
4. 进入解压后的目录 `cd wuyuanbiaoba-web-x.x.x`
5. 运行部署脚本 `sudo ./deploy.sh`
6. 脚本会自动停止现有服务,备份旧版本,安装新版本,并启动服务
7. 部署完成后,可以通过 `sudo systemctl status wuyuanbiaoba-web.service` 查看服务状态
8. 查看日志 `journalctl -u wuyuanbiaoba-web.service -f`

### 离线版本说明

针对设备无法联网的情况，提供离线安装包，离线安装包包含了所有的依赖包，无需联网即可完成安装。

**！！！！注意，依然需要nodejs环境**

离线安装包的部署步骤与在线版本相同，只需下载离线安装包 `wuyuanbiaoba-web-x.x.x-offline.tar.gz` 即可。

## 构建打包

```bash
# 构建生产版本
npm run build

# 打包在线版本
npm run pack

# 打包离线版本
npm run pack:offline
```
