# 高级配置 WebSocket 协议对接文档

1. 主机编码读取指令

```json
{
  "_from": "setup",
  "cmd": "getId",
  "values": {}
}
```

响应示例

```json
{
  "_from": "dev",
  "cmd": "getId",
  "values": {
    "id": "uu1234"
  }
}
```

2. 主机编码设置指令

```json
{
  "_from": "setup",
  "cmd": "setId",
  "values": { "id": "uu1234" }
}
```

响应示例

```json
{
  "_from": "dev",
  "cmd": "setId",
  "values": { "operate": true }
}
```

3. 帧率读取指令

```json
{
  "_from": "setup",
  "cmd": "getDataFps",
  "values": {}
}
```
响应示例

```json
{
  "_from": "dev",
  "cmd": "getDataFps",
  "values": { "dataFps": 10 }
}
```

4. 帧率设置指令

```json
{
  "_from": "setup",
  "cmd": "setDataFps",
  "values": { "dataFps": 10 }
}
```
响应示例

```json
{
  "_from": "dev",
  "cmd": "setDataFps",
  "values": { "operate": true }
}
```

5. 异常超时监控-读取指令
```json
{
  "_from": "setup",
  "cmd": "getAlert",
  "values": {}
}
```
响应示例
```json
{
  "_from": "dev",
  "cmd": "getAlert",
  "values": {
    "enable": false,
    "intervalSec": 6
  }
}
```

6. 异常超时监控-设置指令
```json
{
    "_from": "setup",
    "cmd": "setAlert",
    "values": {
       "enable": false,
        "intervalSec": 6 
    }
}
```
响应示例
```json
{
    "_from": "dev",
    "cmd": "setAlert",
    "values": {
        "operate": true
    }
}
```

7. 滤波-读取
```json
{
  "_from": "setup",
  "cmd":"getWin",
  "values": {}
}
```
响应示例
```json
{
    "_from": "dev",
    "cmd": "getWin",
    "values": {
        "enable": true,
        "method": "median",
        "size": 5,
        "threshold": -0.1,
        "imgThreshold": 10.0
    }
}
```

8. 滤波-设置
```json
{
    "_from": "setup",
    "cmd":"setWin",
    "values": {
        "enable": true,
        "method": "median",
        "size": 5,
        "threshold": -0.1,
        "imgThreshold": 10.0
    }
}
```
响应示例
```json
{
    "_from": "dev",
    "cmd": "setWin",
    "values": {
        "operate": true
    }
}
```

9. mqtt 上报读取
```json
{
  "_from": "setup",
  "cmd":"getMqtt",
  "values": {}
}
```
响应示例
```json
{
  "_from": "dev",
  "cmd": "getMqtt",
  "values": {
    "mqtt": {
      "broker": "218.3.126.49",
      "port": 1883,
      "topic": "wybb/zj/mqtt110_debug",
      "username": "",
      "password": "",
      "client_id": "wybb_debug"
    },
    "enable": true
  }
}
```

10. mqtt上报设置
```json
{
  "_from": "setup",
  "cmd": "setMqtt",
  "values": {
    "mqtt": {
      "broker": "218.3.126.49",
      "port": 1883,
      "topic": "wybb/zj/mqtt110_debug",
      "username": "",
      "password": "",
      "client_id": "wybb_debug"
    },
    "enable": true
  }
}
```
响应示例
```json
{
  "_from": "dev",
  "cmd": "setMqtt",
  "values": {
    "operate": true
  }
}
```
10. 异常超时监控-读取
```json
{
  "_from": "setup",
  "cmd":"getAlert",
  "values": {}
}
```
响应示例
```json
{
    "_from": "dev",
    "cmd": "getAlert",
    "values": {
       "enable": false,
        "intervalSec": 6
    }
}
```
