import React from "react";
import { Table, Typography, Badge } from "antd";

const { Title } = Typography;

const RealtimeDataTable = ({ realtimeData }) => {
   const tableColumns = [
      {
         title: "设备编号",
         dataIndex: "deviceId",
         key: "deviceId",
         render: (deviceId, record) => record.desc || deviceId
      },
      {
         title: "X值(mm)",
         dataIndex: "xValue",
         key: "xValue",

         render: (text) => Number(text),
      },
      {
         title: "Y值(mm)",
         dataIndex: "yValue",
         key: "yValue",

         render: (text) => Number(text),
      },
      {
         title: "更新时间",
         dataIndex: "updateTime",
         key: "updateTime",
      },
   ];

   return (
      <div
         style={{
            flex: 1,
            padding: "16px",
         }}
      >
         <Title level={4} style={{ marginBottom: "16px" }}>
            最新数据
            <Badge
               status="processing"
               text={`${realtimeData.length} 个标靶数据`}
               style={{ marginLeft: "16px", fontSize: "12px" }}
            />
         </Title>
         <div
            style={{
               height: "calc(600px - 60px - 32px)",
               overflow: "hidden",
            }}
         >
            <Table
               bordered
               dataSource={realtimeData}
               columns={tableColumns}
               pagination={false}
               size="small"
            />
         </div>
      </div>
   );
};

export default RealtimeDataTable;
