const path = require('path')
const packageJson = require('./package.json')

const flag = process.env.npm_lifecycle_script.includes('--mode localdev') ? 'localdev' : null;
if (flag) {
   process.env.FS_FLAG = flag;
}
process.env.FS_VERSION = packageJson.version;
module.exports = {
   env: process.env.NODE_ENV || 'development',  // 运行环境 development | production
   port: process.env.PORT || 5000, // 服务端口
   title: 'FreeSun', // 网站标题
   favicon: '/client/assets/favicon.ico', // 网站图标
   scripts: [// 需引入的静态脚本文件
      '/client/assets/script/peace.js'
   ],
   flag: flag, // 自定义环境标识
   version: packageJson.version, // 版本号
   proxy: [{ // 代理配置
      path: '/_api',
      target: process.env.API,
      changeOrigin: true,
      rewrite: (path) => path.replace(/^\/_api/, ""),
      logs: process.env.NODE_ENV == 'development', // 是否打印代理日志
   }],
   vite: { // vite 配置
      envPrefix: 'FS_', // 传递到前端页面 window.env 的环境变量的前缀
      resolve: {
         alias: { // 别名
            '@u': path.join(__dirname, './client/src/utils'),
            '@comps': path.join(__dirname, './client/src/components'),
            '@assets': path.join(__dirname, './client/assets'),
         }
      },
   },
   //---
   xunruan: { // 讯软服务配置
      host: 'http://222.186.227.196:31935'
   },
}
