import React, { Component } from 'react';
import { Result, Button } from 'antd';

class ErrorBoundary extends Component {
   constructor(props) {
      super(props);
      this.state = { hasError: false };
   }

   static getDerivedStateFromError (error) {
      // 更新 state 使下一次渲染能够显示降级后的 UI
      return { hasError: true };
   }

   componentDidCatch (error, errorInfo) {
      // 可以将错误日志上报给服务器
   }

   render () {
      const { errorRender } = this.props;
      if (this.state.hasError) {
         // 可以自定义降级后的 UI 并渲染
         return errorRender || <Result
            status="error"
            title="页面出错了哦!"
            subTitle="请联系管理员进行修复"
         // extra={<Button onClick={() => this.state.navigate(-1)}>返回上一页</Button>}
         />;
      }

      return this.props.children;
   }
}

export default ErrorBoundary;
